/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.common.Counter;
import ibm.nways.jdm.common.Gauge;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.common.TimeTicks;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.StringInput;
import java.awt.TextComponent;

public class LongNumericInput
extends StringInput
implements JDMInput {
    public static final int ERRORTYPE = -1;
    public static final long MIN64SIGNED = Long.MIN_VALUE;
    public static final long MAX64SIGNED = Long.MAX_VALUE;
    public static final long MAX64UNSIGNED = Long.MAX_VALUE;
    public static final long MIN64UNSIGNED = 0L;
    protected long value;
    protected long min = Long.MIN_VALUE;
    protected long max = Long.MAX_VALUE;
    protected long deflt;
    protected int snmptype = 0;

    public LongNumericInput() {
    }

    public LongNumericInput(int n) {
        super("", n);
    }

    public LongNumericInput(long l, int n) {
        super(String.valueOf(l), n);
    }

    public LongNumericInput(long l, long l2, long l3) {
        this(l, l2, l3, l, Math.max((" " + l2).length(), (" " + l3).length()));
    }

    public LongNumericInput(long l, long l2, long l3, int n) {
        this(l, l2, l3, l, n);
    }

    public LongNumericInput(long l, long l2, long l3, long l4, int n) {
        this(l, n);
        this.min = l2;
        this.max = l3;
        this.deflt = l4;
    }

    public boolean isValidValue(String string) {
        this.value = this.deflt;
        if ((string = string.trim()).length() == 0 || string.length() == 1 && string.charAt(0) == '-' && this.min < 0L) {
            return true;
        }
        try {
            this.value = Long.parseLong(string);
            if (this.min <= 0L && this.max >= 0L) {
                return this.value >= this.min && this.value <= this.max;
            }
            if (this.max <= 0L) {
                return this.value >= this.min;
            }
            if (this.min >= 0L) {
                return this.value <= this.max;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isValidValue() {
        if (this.hasErrorValue) {
            return false;
        }
        return this.isValidValue(this.getText()) && this.value >= this.min && this.value <= this.max;
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }

    public long numericValue() {
        if (this.isValidValue()) {
            return this.value;
        }
        return this.deflt;
    }

    public Object getValue() {
        switch (this.snmptype) {
            case 0: {
                return new Long(this.numericValue());
            }
            case 1: {
                return new Counter(this.numericValue());
            }
            case 2: {
                return new Gauge(this.numericValue());
            }
            case 13: {
                return new TimeTicks(this.numericValue());
            }
        }
        return new String(String.valueOf(this.numericValue()));
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(Object object) {
        if (object instanceof Counter) {
            Counter counter = (Counter)object;
            this.value = counter.getValue();
            super.setValue(String.valueOf(this.value));
            this.snmptype = 1;
            return;
        }
        if (object instanceof Gauge) {
            Gauge gauge = (Gauge)object;
            this.value = gauge.getValue();
            super.setValue(String.valueOf(this.value));
            this.snmptype = 2;
            return;
        }
        if (object instanceof TimeTicks) {
            TimeTicks timeTicks = (TimeTicks)object;
            this.value = timeTicks.getValue();
            super.setValue(String.valueOf(this.value));
            this.snmptype = 13;
            return;
        }
        if (object instanceof SpecialValue) {
            SpecialValue specialValue = (SpecialValue)object;
            super.setValue(specialValue);
            this.snmptype = -1;
            return;
        }
        System.err.println("Error: Attempt to set LongNumericInput from " + object.getClass().getName());
    }

    public void setValue(String string) {
        try {
            this.value = Long.parseLong(string);
            super.setValue(string);
            this.isValidValue();
            this.snmptype = 0;
            return;
        }
        catch (NumberFormatException numberFormatException) {
            ((TextComponent)this).setText(string);
            this.hasErrorValue = true;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setMinMax(long l, long l2) {
        this.min = l;
        this.max = l2;
    }
}

